

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

float		LOD_firstLevel;
float		LOD_nextLevel;
float		LOD_changePoint;
float2		sectionPosition;
float2		chunkPosition;
float		chunkSize;
float3		eyePosition;
float		mapSize;

///////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float2	position	:	TEXCOORD0;
	float2	uv			:	TEXCOORD1;
	float	height		:	TEXCOORD2;
	float	nextHeight	:	TEXCOORD3;
};
	
///////////////////////////////////////////////////////////

struct VS_OUTPUT 
{
	float4	position	:	POSITION;
	float2	uv			:	TEXCOORD0;
};

///////////////////////////////////////////////////////////

VS_OUTPUT vs_terrain_far( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = float4(input.position.x + sectionPosition.x,input.height,input.position.y + sectionPosition.y,1);
	
	float nLodDistance = sqrt((eyePosition.x-output.position.x)*(eyePosition.x-output.position.x) + (eyePosition.y-output.position.y)*(eyePosition.y-output.position.y) + (eyePosition.z-output.position.z)*(eyePosition.z-output.position.z));

	if (nLodDistance >= LOD_changePoint)
		output.position.y = lerp( input.height, input.nextHeight, clamp((nLodDistance - LOD_changePoint) / ((LOD_nextLevel - LOD_firstLevel) * 0.25f),0,1) );

	output.position = mul(output.position, shader_transform_viewProj);
	output.uv = input.uv;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
	AddressU=Clamp;
	AddressV=Clamp;
};

sampler sampler_colour_2 = sampler_state
{
	Texture = (shader_texture_1);
	AddressU=Clamp;
	AddressV=Clamp;
};

////////////////////////////////////////////////////////////

float4 ps_terrain_far( VS_OUTPUT input ) : COLOR0
{
	float2 nUv = (chunkPosition + input.uv * chunkSize) * (1.0f / mapSize);
	
	return float4(tex2D(sampler_colour_1, nUv).rgb,1);
}


technique terrain_far_11_20
{
	pass P0
	{
		AlphaBlendEnable = False;
		AlphaTestEnable = False;

		VertexShader = compile vs_1_1 vs_terrain_far();	
		PixelShader = compile ps_2_0 ps_terrain_far();	
	}
}

technique terrain_far_11_00
{
	pass P0
	{
	}
}